import { localhostdomain, WorkDomain } from "@/app/domain";
import { notFound } from "next/navigation";
import dynamic from "next/dynamic";
import { headers } from "next/headers";
import { FetchData } from "@/libs/api";
const HeroDetail = dynamic(() => import("@/sections/HeroDetail"));
const Amenities = dynamic(() => import("@/sections/Amenities"));
const SimpleMap = dynamic(() => import("@/sections/SimpleMap"));
const PaymentPlan = dynamic(() => import("@/sections/PaymentPlan"));
const FloorPlanDetail = dynamic(() => import("@/sections/FloorPlanDetail"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const MortgageCalculator = dynamic(() =>
  import("@/sections/MortgageCalculator")
);
export async function generateMetadata({ params }) {
  const { project_detail } = params;
  const slug = project_detail;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const currectUrl = `https://${domain}/projects/${slug}`;
  const parameter = "project-detail";
  const data = await FetchData(domain, parameter, slug);
  if (data === null) {
    notFound();
  }
  const { project_info } = data;
  const { meta_title, meta_desc, meta_keywords, coverImage } = project_info;
  return {
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: currectUrl,
    },
    openGraph: {
      url: currectUrl,
      images: {
        url: coverImage,
        width: 100,
        height: 100,
      },
    },
  };
}
export default async function page({ params }) {
  const { project_detail } = params;
  const slug = project_detail;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const currectUrl = `https://${domain}/projects/${slug}`;
  const parameter = "project-detail";
  const data = await FetchData(domain, parameter, slug);
  if (data === null) {
    notFound();
  }
  const { project_info, images, amenities, Floor_plan } = data;
  const {
    property_name,
    latitude,
    longitude,
    meta_title,
    meta_desc,
    meta_keywords,
  } = project_info;
  if (!data) {
    notFound();
  }
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={currectUrl}
      />
      <RatingSchema title={meta_title} />
      <HeroDetail images={images} currectUrl={currectUrl} data={project_info} />
      {amenities && amenities.length > 0 && <Amenities data={amenities} />}
      <PaymentPlan payment_plan={project_info} community_name={property_name} />
      <FloorPlanDetail Floor_plan={Floor_plan} property_name={property_name} />
      {longitude && longitude.length > 0 && (
        <SimpleMap
          lat={longitude}
          lag={latitude}
          property_name={property_name}
        />
      )}
      <MortgageCalculator />
    </>
  );
}
